#include <iostream>
#include <inttypes.h>
#include <stdlib.h>

using namespace std;

typedef struct {
    uint32_t qFront;
    uint32_t qBack;
    uint32_t* data;
    uint32_t elementsCount;
} queue_t;

void queue_push(queue_t* q, uint32_t val, uint32_t queueCapacity) {
    q->qBack=(q->qBack+1)%queueCapacity;
    if(q->elementsCount==0) q->qFront=q->qBack;
    q->data[q->qBack]=val;
    q->elementsCount++;
    return;
}

uint32_t queue_front(queue_t* q) {
    return q->data[q->qFront];
}

void queue_pop(queue_t* q, uint32_t queueCapacity) {
    q->qFront=(q->qFront+1)%queueCapacity;
    q->elementsCount--;
    return;
}


int main()
{
    uint32_t n, q;
    scanf("%"SCNu32 " %"SCNu32, &n, &q);
    uint32_t A[n];
    for(uint32_t i=0;i<n;i++) {
        scanf("%"SCNu32, &A[i]);
    }

    // Podnizovi
    queue_t kju;
    kju.data=(uint32_t *)malloc(sizeof(uint32_t)*n);
    kju.elementsCount=0;
    kju.qFront=0; kju.qBack=0;
    for(uint32_t i=0;i<q;i++) {
        uint32_t L, R;
        kju.elementsCount=0;
        kju.qFront=0; kju.qBack=0;
        scanf("%"SCNu32 " %"SCNu32, &L, &R);
        // Dodamo u queue one koji nisu u dobrom nizu (za pocetak dodajemo 0. index)
        queue_push(&kju, L-1, n);
        uint32_t longestGoodSubset=0;
        while(kju.elementsCount!=0) {
            uint32_t currentIndex=queue_front(&kju);
            uint32_t lastElement=A[currentIndex];
            uint32_t currentGoodSubset=0;
            queue_pop(&kju, n);
            for(uint32_t curr=currentIndex;curr<R;curr++) {
                            //printf("current = A[%u] = %u\nLast element = %u\n", curr, A[curr], lastElement);
                if((A[curr]&lastElement)>(A[curr]^lastElement)) {
                    lastElement=A[curr];
                    currentGoodSubset++;
                            //printf("Changed last element to %u\n", lastElement);
                }
                else {
                            //printf("Pushed back %u\n", curr);
                    queue_push(&kju, curr, n);
                }
            }
            //printf("\n");
            if(currentGoodSubset>longestGoodSubset) {
                longestGoodSubset=currentGoodSubset;
            }
        }
        cout << longestGoodSubset << endl;
    }
    return 0;
}